# Detect-BIOSUpdate.ps1 (robust)
# Exit 0 = Installed; Exit 1 = Not installed

$ErrorActionPreference = 'SilentlyContinue'

$CompanyRegRoot = 'HKLM:\SOFTWARE\Contoso\BiosUpdates'
$TagDir         = 'C:\ProgramData\BiosUpdates\Tags'

# 1) Tag file check: any *_success.tag present?
if (Test-Path -LiteralPath $TagDir) {
    $tags = Get-ChildItem -LiteralPath $TagDir -Filter '*_success.tag' -File
    if ($tags) {
        # Optional freshness gate: uncomment to require recent tag (e.g., <= 14 days)
        # $fresh = $tags | Where-Object { ((Get-Date) - $_.LastWriteTime).TotalDays -le 14 }
        # if ($fresh) { exit 0 }
        exit 0
    }
}

# 2) Registry check: any model subkey with Status = 'Success'?
if (Test-Path -LiteralPath $CompanyRegRoot) {
    $subKeys = Get-ChildItem -LiteralPath $CompanyRegRoot -ErrorAction SilentlyContinue
    foreach ($k in $subKeys) {
        $p = Get-ItemProperty -Path $k.PSPath -ErrorAction SilentlyContinue
        if ($null -ne $p -and $p.Status -eq 'Success') {
            # Optional freshness gate: uncomment to require recent completion (e.g., <= 14 days)
            # if ($p.CompletedUtc) {
            #     $when = [datetime]::Parse($p.CompletedUtc)
            #     if (((Get-Date) - $when).TotalDays -le 14) { exit 0 }
            # } else {
            #     exit 0
            # }
            exit 0
        }
    }
}

# 3) (Optional) BIOS version gate — uncomment & set a target/min version if you want:
# $current = (Get-CimInstance Win32_BIOS).SMBIOSBIOSVersion
# if ($current -ge '2208') { exit 0 }

exit 1
