@echo off
setlocal

REM --------------------------------------------
REM  Launch wrapper for ASUS BIOS Updater
REM  - Ensures PowerShell runs with admin rights
REM  - Bypasses execution policy
REM  - Runs flash.ps1 in the package directory
REM --------------------------------------------

set SCRIPT_DIR=%~dp0
set PS_SCRIPT=%SCRIPT_DIR%flash.ps1

REM --- Check for Administrator privileges ---
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] This script must be run as Administrator.
    echo Right-click and select "Run as administrator".
    pause
    exit /b 1
)

REM --- Run PowerShell script ---
echo Running ASUS BIOS Updater V1.0...
powershell.exe -NoProfile -ExecutionPolicy Bypass -File "%PS_SCRIPT%"
set EXITCODE=%ERRORLEVEL%

echo.
echo Script finished with exit code %EXITCODE%
pause

exit /b %EXITCODE%
